%! Class = ipu-ai
%! Author = Sujal Singh
%! Date = 11/28/24

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{iot-report}[A class for IoT lab project report.]

\LoadClass[a4paper,12pt,twoside]{article}

% --- Packages ---
\RequirePackage{lmodern}
\RequirePackage{graphicx}
\RequirePackage{tabularray}
\RequirePackage[a4paper,margin=1.5in]{geometry}
\RequirePackage[outputdir=./build]{minted}
\RequirePackage[most,minted,listings]{tcolorbox}
\RequirePackage{tikz}
\usetikzlibrary{shapes.geometric, arrows, calc}

% --- Arguments ---
\renewcommand{\@author}{Sujal Singh}
\newcommand{\@rollno}{04119051723}
\newcommand{\@batch}{IIOT--B1--23}
\newcommand{\@doctitle}{Internet of Things Lab -- Project Report}
\newcommand{\@projecttitle}{Filament Drying Box}
\renewcommand{\author}[1]{\renewcommand{\@author}{#1}}
\newcommand{\rollno}[1]{\renewcommand{\@rollno}{#1}}
\newcommand{\batch}[1]{\renewcommand{\@batch}{#1}}
\newcommand{\doctitle}[1]{\renewcommand{\@doctitle}{#1}}
\newcommand{\projectreport}[1]{\renewcommand{\@projecttitle}{#1}}


% --- Title Page ---
\renewcommand*{\maketitle}{
    \thispagestyle{empty}
    \pagenumbering{gobble}
    \vspace*{5pt}\noindent%
    \begin{minipage}{0.2\textwidth}
        \includegraphics[width=0.95\linewidth]{logo}~~~~~\vline
    \end{minipage}%
    \hfill%
    \begin{minipage}{0.75\textwidth}%
        \textbf{\Large Guru Gobind Singh Indraprastha University}\\[10pt]%
        {\large University School of Automation \& Robotics}
    \end{minipage}\vfill%
    \begin{center}
        \rule{\textwidth}{2pt}\\[30pt]%
        \textbf{\Large \@doctitle}\\[20pt]%
        \textbf{\large \@projecttitle}%
        \\[25pt]\rule{\textwidth}{2pt}\\\vfill%
        {\large\begin{tblr}{width=1\textwidth,colspec={|X[c]|X[c]|},rows=30pt,hlines}
                   \textbf{Name}              & \@author \\
                   \textbf{Enrollment Number} & \@rollno \\
                   \textbf{Batch}             & \@batch  \\
                   \textbf{Submitted to}      & \ Dr. Khyati Chopra \\
        \end{tblr}}\\[20pt]%
    \end{center}
    \newpage
    \pagenumbering{arabic}
}

% --- Setup Long Table for Index ---
\DefTblrTemplate{caption}{default}{}    % Removes a caption
\DefTblrTemplate{capcont}{default}{}    % Removes a caption on subsequent pages
\DefTblrTemplate{contfoot}{default}{}   % Removes text denoting continuation on next page


\usemintedstyle{bw}
% Changes minted line number size
\renewcommand{\theFancyVerbLine}{\parbox{10pt}{\centering\footnotesize\arabic{FancyVerbLine}}}

\newtcblisting{code}[2]{
    listing only,
    listing engine=minted,
    minted language=#2,
    breakable,
    enhanced,
    colback=white,
    coltitle=black,
    colbacktitle=white,
    top=0pt,
    bottom=0pt,
    sharp corners,
    title=\textbf{#1:},
    minted options = {
        linenos,
        stripall,
        breaklines,
        xleftmargin=10pt,
    },
    overlay={%
        \begin{tcbclipinterior}
            \draw [line width=1pt] (frame.north west) rectangle ([xshift=18pt]frame.south west);
        \end{tcbclipinterior}
    }}

\BeforeBeginEnvironment{code}{\vspace*{-18pt}}

\newtcolorbox{tabularsection}[1]{
    breakable,
    enhanced,
    colback=white,
    coltitle=black,
    colbacktitle=white,
    top=0pt,
    bottom=0pt,
    sharp corners,
    title=\textbf{#1:},
}
