# Create a .csv file (with contents like age, weight and BMI). Read the content of the file and using Pandas and
# MatPlotLib, plot the graph.

import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

data = pd.read_csv("data.csv")
bmi = []
for row in data.iterrows():
    age, weight, height = row[1]
    bmi.append(weight / (height / 100) ** 2)
data["BMI"] = bmi

figure, ax = plt.subplots()
ax.plot(data["age"], data["BMI"], "ro")
plt.show()
